#include "functions.inc"
#include "transforms.inc"

#declare scrubTexture = texture {
	pigment {
		spherical
		color_map {
			[ 0.00 color rgb <.4, .4, 1> ]
			[ 0.01 color rgb <.1, .1, 1>]
			[ 0.30 color rgb <.1, .4, 1> ]
			[ 1.00 color rgb <.1, .2, 1> ]
		}
		//color Blue
		turbulence .2
	}
	finish {
		ambient .7
		reflection 0.1
		specular 0.2
		roughness 0.3
	}
}

#declare scrubbrush = isosurface {
	function {
		f_sphere(x,y,z,1) + f_granite(x*.125,y*.125,z*.125)*.9 - f_granite(x*2,y*2,z*2)*.9
	}
	max_gradient 2
	contained_by{ sphere{ 0,2 } }
	scale <.75, .5, .75>
	double_illuminate
}


#declare brushCount = 150;
#declare availableRadius = simple_radius*.71;
#declare treeLine = landHeight*.8;
#declare brushPlaces = seed(978998);
#while (brushCount > 0)
	#declare brushX = rand(brushPlaces)*availableRadius*2-availableRadius;
	#declare brushZ = rand(brushPlaces)*availableRadius*2-availableRadius;
	#declare brushSize = rand(brushPlaces)+.5;
	#declare brushStart = <brushX, sun_height, brushZ>;
	#declare brushLoc = trace(land, brushStart, <0, -1, 0>, nvector);
	#if (vlength(nvector) > 0)
		#if (brushLoc.y < treeLine)
			object { scrubbrush
				Reorient_Trans(y,nvector)
				scale brushSize
				translate brushLoc
				texture{ scrubTexture
					scale brushSize
				}
			}
		#end
	#else
		#debug concat("Could not find landfall for bush at ", vstr(3, brushStart, ", ", 0, 1), ".\n")
		cylinder {
			<brushStart.x, -simple_radius, brushStart.z>, <brushStart.x, simple_radius, brushStart.z>, 3
			pigment {
					color Yellow
			}
		}
	#end

	#declare brushCount = brushCount - 1;
#end

